﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using AZVIC.Ei8htPOS.POSRetail.Constants;
using AZVIC.Ei8htPOS.POSRetail.Pages;
using AZVIC.Ei8htPOS.POSRetail.Controls;
namespace AZVIC.Ei8htPOS.POSRetail
{
    /// <summary>
    /// Interaction logic for Menu.xaml
    /// </summary>
    public partial class Menu : UserControl
    { 
        
        #region Variables
        private string ActiveMenu { get; set; }
        private MasterWindow Master { get; set; } 
        #endregion

        #region Constructors
        public Menu()
        {
            InitializeComponent();
        }
        public Menu(string SelectedText)
        {
            InitializeComponent();
            ActiveMenu = SelectedText;
            Master = new MasterWindow();
            
        }
        
        #endregion
       
        #region Event Handlers
        private void Menu_Loaded(object sender, RoutedEventArgs e)
        {
            //(this.FindName(ActiveMenu) as Button).Foreground = Brushes.White;
            //(this.FindName(ActiveMenu.Replace("btn", "rct")) as Rectangle).Fill = Brushes.Black;
        }

        private void btnOrder_Click(object sender, RoutedEventArgs e)
        {
            Master.LoadPages(new Ordering(),Menus.ORDER);
        }

        private void btnReport_Click(object sender, RoutedEventArgs e)
        {
            Master.LoadPages(new Reports(),Menus.REPORT);
        }

        private void btnInventory_Click(object sender, RoutedEventArgs e)
        {
            Master.LoadPages(new Inventory(), Menus.INVENTORY);
        }

        private void btnCustomers_Click(object sender, RoutedEventArgs e)
        {
            Master.LoadPages(new Customers(), Menus.CUSTOMERS);
        }

        private void btnLogoff_Click(object sender, RoutedEventArgs e)
        {
            LogoffConfirmation LogoffWindow = new LogoffConfirmation();
            LogoffWindow.ShowDialog();
        }
        
        private void btnAdmin_Click(object sender, RoutedEventArgs e)
        {
           Master.LoadPages(new Admin(), Menus.ADMIN);
        }
        #endregion

       
    }
}
